package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.CierreMasivo;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * CierreMasivoDaoImpl NO generated by UDA, 28-ago-2017.
 * 
 * @author NO UDA
 */

@Repository()
@Transactional()
public class CierreMasivoDaoImpl implements CierreMasivoDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Gets the jdbc template.
	 * 
	 * JdbcTemplate
	 * 
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<CierreMasivo> rwMap = new RowMapper<CierreMasivo>() {
		public CierreMasivo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new CierreMasivo(resultSet.getString("TEROS"),
					resultSet.getString("ANOOS"), resultSet.getLong("NUMOS"),
					resultSet.getDate("FECPRE"), resultSet.getString("NOMEMP"),
					resultSet.getString("NUMDOC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Finds rows in the Ab04b56s00 or Ab04b60s00 or Ab04b61s00 table joined
	 * with Ab04b77s00.
	 * 
	 * cierreMasivo CierreMasivo
	 * 
	 * jqGridRequestDto JQGridRequestDto List<CierreMasivo>
	 * 
	 * @param cierreMasivo
	 *            the cierre masivo
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<CierreMasivo> findCierreMasivo(CierreMasivo cierreMasivo,
			JQGridRequestDto jqGridRequestDto) {

		String mascara = Utilities.getInstance().getDateMask();
		// Pongo uno de los tres, en este caso el de apertura

		String select = "t1.TERAPE TEROS, t1.ANOAPE"
				+ " ANOOS, t1.NUMAPE NUMOS, t1.FECPRE"
				+ " FECPRE, t1.NOMEMP NOMEMP, t1.NUMDOC NUMDOC";

		String where = " AND NOT EXISTS (SELECT '1' FROM VTAREAS_TRAMITES_APERTURAS WHERE TERRIT_APERTURA_062=t1.terape  "
				+ "AND ANO_APERTURA_062=t1.anoape  AND num_apertura_062 =t1.numape  AND estado_063<>2) "

				+ " AND t1.TERAPE = '"
				+ cierreMasivo.getTerritorioExpediente077() + "'";

		StringBuilder query = new StringBuilder("SELECT ");
		query.append(select);

		query.append(" FROM VCOMUNICACION_APERTURA t1  ");

		query.append(" WHERE  ");

		query.append(" t1.ESTADO = 'A' and t1.folderid is not null ");

		if (null != cierreMasivo.getTerritorioExpediente077()) {
			query.append(where);
		}

		if (null != cierreMasivo.getFecpreDesdeStr()
				&& !"".equals(cierreMasivo.getFecpreDesdeStr())) {
			query.append(" AND TRUNC(FECPRE) >= trunc(to_date('"
					+ cierreMasivo.getFecpreDesdeStr() + "', '" + mascara
					+ "')) ");
		}

		if (null != cierreMasivo.getFecpreHastaStr()
				&& !"".equals(cierreMasivo.getFecpreHastaStr())) {
			query.append(" AND TRUNC(FECPRE) <= trunc(to_date('"
					+ cierreMasivo.getFecpreHastaStr() + "', '" + mascara
					+ "')) ");
		}

		// ANOAPE
		if (null != cierreMasivo.getAnoape()
				&& !"".equals(cierreMasivo.getAnoape())) {
			query.append(" AND ANOAPE = " + cierreMasivo.getAnoape());
		}

		// estado visita osalan
		if (cierreMasivo.getVisosl() != null) {
			query.append(" AND UPPER(VISOSL) = '"
					+ cierreMasivo.getVisosl().toUpperCase() + "' ");
		}
		// indicador obra
		if (cierreMasivo.getIndobra() != null) {
			query.append(" AND UPPER(INDOBRA) = '"
					+ cierreMasivo.getIndobra().toUpperCase() + "' ");
		}
		// tiene informe osalan
		if (cierreMasivo.getIndInfOsalan() != null) {
			if (Constantes.VALUE_SI.equals(cierreMasivo.getIndInfOsalan())) {
				query.append(" AND FINFOSL IS NOT NULL");
			} else if (Constantes.VALUE_NO.equals(cierreMasivo
					.getIndInfOsalan())) {
				query.append(" AND FINFOSL IS NULL");
			}
		}

		// tiene informe inspeccion
		if (cierreMasivo.getIndInfInsp() != null) {
			if (Constantes.VALUE_SI.equals(cierreMasivo.getIndInfInsp())) {
				query.append(" AND FINFINSP IS NOT NULL");
			} else if (Constantes.VALUE_NO.equals(cierreMasivo.getIndInfInsp())) {
				query.append(" AND FINFINSP IS NULL");
			}
		}

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<CierreMasivo>) this.getJdbcTemplate().query(
				query.toString(), this.rwMap);
	}

	/**
	 * Finds rows in the Ab04b56s00 or Ab04b60s00 or Ab04b61s00 table joined
	 * with Ab04b77s00.
	 * 
	 * cierreMasivo CierreMasivo
	 * 
	 * Long
	 * 
	 * @param cierreMasivo
	 *            the cierre masivo
	 * @return the long
	 */
	public Long findCierreMasivoCount(CierreMasivo cierreMasivo) {

		String mascara = Utilities.getInstance().getDateMask();
		// Pongo uno de los tres, en este caso el de apertura

		String where = " AND NOT EXISTS (SELECT '1' FROM VTAREAS_TRAMITES_APERTURAS WHERE TERRIT_APERTURA_062=t1.terape  "
				+ "AND ANO_APERTURA_062=t1.anoape  AND num_apertura_062 =t1.numape  AND estado_063<>2) "

				+ " AND t1.TERAPE = '"
				+ cierreMasivo.getTerritorioExpediente077() + "'";

		StringBuilder query = new StringBuilder("SELECT COUNT(1) ");

		query.append(" FROM VCOMUNICACION_APERTURA t1  ");

		query.append(" WHERE  ");

		query.append(" t1.ESTADO = 'A' and t1.folderid is not null ");

		if (null != cierreMasivo.getTerritorioExpediente077()) {
			query.append(where);
		}

		if (null != cierreMasivo.getFecpreDesdeStr()
				&& !"".equals(cierreMasivo.getFecpreDesdeStr())) {
			query.append(" AND TRUNC(FECPRE) >= trunc(to_date('"
					+ cierreMasivo.getFecpreDesdeStr() + "', '" + mascara
					+ "')) ");
		}

		if (null != cierreMasivo.getFecpreHastaStr()
				&& !"".equals(cierreMasivo.getFecpreHastaStr())) {
			query.append(" AND TRUNC(FECPRE) <= trunc(to_date('"
					+ cierreMasivo.getFecpreHastaStr() + "', '" + mascara
					+ "')) ");
		}

		// ANOAPE
		if (null != cierreMasivo.getAnoape()
				&& !"".equals(cierreMasivo.getAnoape())) {
			query.append(" AND ANOAPE = " + cierreMasivo.getAnoape());
		}

		// estado visita osalan
		if (cierreMasivo.getVisosl() != null) {
			query.append(" AND UPPER(VISOSL) = '"
					+ cierreMasivo.getVisosl().toUpperCase() + "' ");
		}
		// indicador obra
		if (cierreMasivo.getIndobra() != null) {
			query.append(" AND UPPER(INDOBRA) = '"
					+ cierreMasivo.getIndobra().toUpperCase() + "' ");
		}
		// tiene informe osalan
		if (cierreMasivo.getIndInfOsalan() != null) {
			if (Constantes.VALUE_SI.equals(cierreMasivo.getIndInfOsalan())) {
				query.append(" AND FINFOSL IS NOT NULL");
			} else if (Constantes.VALUE_NO.equals(cierreMasivo
					.getIndInfOsalan())) {
				query.append(" AND FINFOSL IS NULL");
			}
		}

		// tiene informe inspeccion
		if (cierreMasivo.getIndInfInsp() != null) {
			if (Constantes.VALUE_SI.equals(cierreMasivo.getIndInfInsp())) {
				query.append(" AND FINFINSP IS NOT NULL");
			} else if (Constantes.VALUE_NO.equals(cierreMasivo.getIndInfInsp())) {
				query.append(" AND FINFINSP IS NULL");
			}
		}

		return this.getJdbcTemplate().queryForLong(query.toString());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
